# ast38.inc
# scenario file for 1938 scenario
# Amended by Andrew S. Davidson on 12 March 2005
# Andrew Davidson 17-Sep-05 tech and diplomacy tweaks
# ASD - 2-Oct-05 - reduce AA

province = { id = 1703 ic = 1 } # Darwin
province = { id = 1722 ic = 4 } # Brisbane
province = { id = 1724 ic = 2 } # Newcastle
province = { id = 1727 ic = 3 } # Sydney
province = { id = 1730 ic = 2 } # Melbourne
province = { id = 1733 ic = 3 } # Adelaide

province = { id = 1712 landfort = 0 coastalfort = 1 } #Perth
province = { id = 1722 landfort = 0 coastalfort = 1 } #Brisbane
province = { id = 1727 landfort = 0 coastalfort = 2 } #Sydney
province = { id = 1730 landfort = 0 coastalfort = 1 } #Melbourne

# AA negligble - Raid on Darwin in 42 - only one plane shot down

province = { id = 1725   anti_air = 1 } #Sydney

# Rabaul
province = {id = 1670 
		naval_base = {size = 6 current_size = 6} 
		air_base = {size = 1 current_size = 1 }}
# Lae
province = { id = 1672 
		air_base = { size = 1 current_size = 1 }}

# Port Moresby
province = { id = 1679
		naval_base = { size = 6 current_size = 6 } 
		air_base = { size = 2 current_size = 2 }}
# Darwin
province = {id = 1703 
		naval_base = {size = 6	current_size = 6}
		air_base = {size = 2 current_size = 2}}
# Perth
province = {id = 1712
		naval_base = {size = 6	current_size = 6}
		air_base = {size = 2 current_size = 2}}
# Brisbane
province = {id = 1722
		naval_base = {size = 10	current_size = 10}
		air_base = {size = 2 current_size = 2}}
# Sydney
province = {id = 1727
		naval_base = {size = 10 current_size = 10 }
		air_base = {size = 4 current_size = 4}}

country = {
    tag = AST

	policy = {
        date = { year = 0 month = january day = 0 }
        democratic = 9
        political_left = 2
        free_market = 8
        freedom = 10
        professional_army = 5
        defense_lobby = 2
        interventionism = 3
		    }
	headofstate = { type = 9 id = 56031 }
	headofgovernment = { type = 9 id = 56002 }
 	foreignminister = { type = 9 id = 56045 }
 	armamentminister = { type = 9 id = 56057 }
 	ministerofsecurity = { type = 9 id = 56080 }
 	ministerofintelligence = { type = 9 id = 56094 }
 	chiefofstaff = { type = 9 id = 56105 }
 	chiefofarmy = { type = 9 id = 56113 }
 	chiefofnavy = { type = 9 id = 56119 }        
 	chiefofair = { type = 9 id = 56124 }

	dormant_ministers = { 56001 56003 56004 56083 56005 56007 }

	peacetime_ic_mod = 0.2  # this will keep spending tight (20%) until outbreak of war

	ai = "AST_1936.ai"

	manpower	= 10
	energy		= 10000   
	metal		= 10000		
	rare_materials	= 2000	
	oil		= 500	
	supplies	= 500
	money		= 100
	capital		= 1728


	ownedprovinces =      {
		1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721
		1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733
		1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1734

		1666 1667 1672 1675 1676 1677 1678 1679 1680 # New Guinea
		1668 # Admiralty Island
		1669 1670 1671 1681 # Bismarck Archipelago
				}
	controlledprovinces = {
		1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721
		1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733
		1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1734

		1666 1667 1672 1675 1676 1677 1678 1679 1680 # New Guinea
		1668 # Admiralty Island
		1669 1670 1671 1681 # Bismarck Archipelago
				}
	nationalprovinces =   {
		1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721
		1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733
		1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1734
				}

diplomacy = {
relation = { tag = BEL value = 75 }
relation = { tag = BHU value = 150 }
relation = { tag = CAN value = 200 }
relation = { tag = ENG value = 200 }
relation = { tag = FRA value = 100 }
relation = { tag = GER value = -150 }
relation = { tag = ITA value = -50 }
relation = { tag = JAP value = -100 }
relation = { tag = NEP value = 150 }
relation = { tag = NZL value = 200 }
relation = { tag = OMN value = 150 }
relation = { tag = SAF value = 200 }
relation = { tag = USA value = 125 }
}

techapps = {
1010 # Great War Infantry
1020 # Early Infantry
1110 # Basic Mountain
1150 # Basic Marine
1190 # Great War Cavalry Division
1200 # Early Cavalry Division
1210 # Basic Cavalry Division
1310 # Rear Area Supply Dumps
1340 # Rear Area Vehicle Repair Shop
2010 # Great War Tank
2020 # Tankette
2030 # Early Tank
2150 # Basic Armoured Car
2290 # Great War Light Field Artillery
2300 # Great War Medium Field Artillery
2310 # Great War Heavy Field Artillery
2320 # Early Field Artillery
2400 # Basic AT
2450 # Great War Static Anti-Air Artillery
2460 # Early Static AA
3010 # Great War Destroyer
3020 # Early Destroyer
3030 # Basic Destroyer
3070 # Great War Light Cruiser
3080 # Early Light Cruiser
3090 # Basic Light Cruiser
3100 # Improved Light Cruiser
3130 # Great War Heavy Cruiser
3140 # Early Heavy Cruiser
3150 # Basic Heavy Cruiser
3400 # Dive Boat
3410 # Short Range Submarine
4010 # Interwar Fighter
4020 # Early Fighter
4030 # Basic Interceptor
4120 # Interwar Bomber
4130 # Early Bomber
4140 # Basic Tactical Bomber
4190 # Basic Naval Bomber
5010 # Modern Agriculture
5020 # Mechanized Agriculture
5030 # Agrichemistry
5050 # Basic Machine Tools
5080 # Basic Construction Engineering
5090 # Improved Construction Engineering
5190 # Basic Oil Refining
5200 # Improved Oil Refining
5310 # Census Tabulating Machine
5320 # Basic Computing Machine
5350 # Basic Encryption Devices
5360 # Basic Decryption Devices
6010 # Firepower Focus Doctrine
6030 # Grand Battle Plan Doctrine
6110 # Mass Assault Doctrine
8010 # Decisive Battle Doctrine
8020 # Naval Firepower Doctrine
8040 # Fleet Auxiliary Submarine Doctrine
8050 # Convoy Sailing Doctrine
8070 # Fleet-in-Being Doctrine
8120 # Battlefleet Concentration Doctrine
8310 # Floating Fortress Doctrine
9010 # Air Superiority Doctrine
9020 # Flying Circus Doctrine
9030 # Force Substitution Doctrine
9090 # Operational Destruction Doctrine
	}

###	1932:  The total Militia was only 28,000 men strong
###	Regular Army had about 1500 men (mostly coastal artillery)
###	This was brought upto 46,000 by 1938
###	In 1939, total was 82800 of whom only 2800 were regulars.



########## Australian Army ##############



landunit = {
 	id = { type = 30001 id = 1 }
 	name = "1st Military District"
 	location = 1722 # Brisbane
  		division = {
   		id = { type = 30001 id = 2 }
   		name = "Queensland Cameron Highlanders"
   		strength = 50
   		type = garrison}}

landunit = {
 	id = { type = 30001 id = 3 }
 	name = "2nd Military District"
 	location = 1727
  		division = {
   		id = { type = 30001 id = 4 }
   		name = "1st Infantry Division"
   		strength = 50
   		type = garrison	}
		division = {
   		id = { type = 30001 id = 5 }
   		name = "2nd Infantry Division"
   		strength = 50
   		type = garrison	}
		division = {
   		id = { type = 30001 id = 6 }
   		name = "1st Cavalry Division"
   		strength = 80
   		type = garrison	}}

landunit = {
 	id = { type = 30001 id = 7 }
 	name = "3rd Military District"
 	location = 1730
  		division = {
   		id = { type = 30001 id = 8 }
   		name = "3rd Infantry Division"
   		strength = 50
   		type = garrison	}
		division = {
   		id = { type = 30001 id = 9}
   		name = "4th Infantry Division"
   		strength = 50
   		type = garrison	}
		division = {
   		id = { type = 30001 id = 10 }
   		name = "2nd Cavalry Division"
   		strength = 80
   		type = garrison	}}


landunit = {
 	id = { type = 30001 id = 11 }
 	name = "4th Military District"
 	location = 1733
  		division = {
   		id = { type = 30001 id = 12 }
   		name = "Adelaide Rifles"
   		strength = 50
   		type = garrison }
		}


landunit = {
 	id = { type = 30001 id = 13 }
 	name = "5th Military District"
 	location = 1712
  		division = {
   		id = { type = 30001 id = 14 }
   		name = "Swan Regiment"
   		strength = 50
   		type = garrison}}

landunit = {
 	id = { type = 30001 id = 15 }
 	name = "6th Military District"
 	location = 1729 # Tasmania
  		division = {
   		id = { type = 30001 id = 16 }
   		name = "Tasmanian Rangers"
   		strength = 50
   		type = garrison}}

landunit = {
 	id = { type = 30001 id = 17 }
 	name = "7th Military District"
 	location = 1703
  		division = {
   		id = { type = 30001 id = 18 }
   		name = "Darwin Fortress"
   		strength = 20
   		type = garrison
   		}
	}

landunit = {
 	id = { type = 30001 id = 19 }
 	name = "Port Moresby Garrison"
 	location = 1679
  		division = {
   		id = { type = 30001 id = 20 }
   		name = "Port Moresby Garrison"
   		strength = 10
   		type = garrison
		}
		}

airunit = {
 	location = 1703
	base = 1703
	id = { type = 30001 id = 50 }
	name = "RAAF Laverton"
		division = {
		id = { type = 30001 id = 51 }
		name = "No.2 RAAF Tactical Group"
		strength = 20
		type = tactical_bomber model = 0 }
		}

airunit = {
 	location = 1727
	base = 1727
	id = { type = 30001 id = 52 }
	name = "RAAF Richmond"
		division = {
		id = { type = 30001 id = 53 }
		name = "No.1 RAAF Naval Bomber Group"
		strength = 30
		type = naval_bomber model = 0 }
		}


########## Australian Navy ##############

# HMAS Perth was still HMS Amphion in 1938

navalunit = {
	id = { type = 30001 id = 100 }
	name = "Royal Australian Navy"
	location = 1727
	base = 1727
	division = { id = { type = 30001 id = 101 } name = "HMAS Australia" type = heavy_cruiser model = 1 }
	division = { id = { type = 30001 id = 102 } name = "HMAS Canberra" type = heavy_cruiser model = 1 }
	division = { id = { type = 30001 id = 103 } name = "HMAS Sydney" type = light_cruiser model = 2 }
	division = { id = { type = 30001 id = 104 } name = "HMAS Hobart" type = light_cruiser model = 1 }
	division = { id = { type = 30001 id = 105 } name = "HMAS Adelaide" type = light_cruiser model = 0 }
	division = { id = { type = 30001 id = 106 } name = "RAN Destroyer Flotilla" type = destroyer model = 0 }
	division = { id = { type = 30001 id = 107 } name = "RAN Destroyer Flotilla" type = destroyer model = 1 }
	}

# Australia had a small merchant marine.  Shown are the three liners converted as AMCs
# and then used as landing ships

navalunit = {
	id = { type = 30001 id = 108 }
	name = "RAN Landing Ships"
	location = 1727
	base = 1727
	division = { id = { type = 30001 id = 109 } name = "HMAS Kanimbla" type = transport }
	division = { id = { type = 30001 id = 110 } name = "HMAS Manoora" type = transport }
	division = { id = { type = 30001 id = 111 } name = "HMAS Westralia" type = transport }
	}


transports = 30
escorts = 2
} 
